/*
 *  Module:   curvature directions
 *
 *  Programs: impcurv and parcurv (implicit and parametric curvature lines 
 *              generators for project Riemann)
 */

#include "curvature.h"

/*
 *   Function: cd
 *
 *   Purpose:  cd (dist dt initial.point old.init.dir cdfunc)
 *	         program for the curvature directions ParCurv
 *	         called by CurvatureDirections
 *
 *   Author:	Jim Lambers
 *
 */

void	cd(scDist, MaxFunc, scDt, GFunc, pvctInitialPoint, pvctOldInitDir, 
  pvctOldCd, avctPoints)
SCALAR	scDist;			/* Curvature line distance, in units */
int	MaxFunc;
SCALAR	scDt, (*GFunc)();
PVECTOR	pvctInitialPoint, pvctOldInitDir, pvctOldCd;
VECTOR	avctPoints[];
{
    int		i;


    for (i = 0; i < 3; i++) {
	pvctOldCd->vars[i] = pvctOldInitDir->vars[i];
	vctInitPointForRK.vars[i] = pvctInitialPoint->vars[i];
    }

    RungeKutta( (SCALAR) 0.0, scDist, (short) MaxFunc, scDt, GFunc,
      pvctInitialPoint, avctPoints );
}

