/*
 *  Module:   mesh
 *
 *  Programs: impcurv and parcurv (implicit and parametric curvature lines 
 *              generators for project Riemann)
 */

#include "parametric.h"

/*
 *    Function:	Mesh
 *
 *    Author:	Jim Lambers
 */

void	mesh(scDrawUnits, scOtherSteps, scSpacing, gfunc, scStep, 
  avctCDDrawLines, avctCDOtherLines, pvctOldCD)
SCALAR  scDrawUnits;	      /* Length, in units, of curvature lines drawing */
SCALAR  scOtherSteps;	      /* Length, in steps, of curvature line in other */
			      /*   direction */
SCALAR  scSpacing;
SCALAR	(*gfunc)(), scStep;
VECTOR	avctCDDrawLines[], avctCDOtherLines[];
PVECTOR	pvctOldCD;
{
    SCALAR	sc;
    int		k;
    VECTOR	vctTemp, vctOldDir;
    SCALAR	scSpacingSteps;	   /* Number of steps between curvature lines */
    int		DrawPoints;	   /* Number of points on curv. line drawing */
#ifdef MOEBIUS
    int		j;
    VECTOR	vctMoebiusTemp;
#endif

    /* Compute the number of columns in array avctCDDrawLines */
    DrawPoints = (int) (scDrawUnits / scStep) + 1;

    scSpacingSteps = scSpacing / scStep;

    for (sc = scSpacingSteps, k = 1; sc <= scOtherSteps; sc += scSpacingSteps, 
      k++) {
	VctMinusVct( &(avctCDDrawLines[(k-1)*DrawPoints + 1]), 
          &(avctCDDrawLines[(k-1)*DrawPoints]), &vctTemp );
	Normalize(&vctTemp, &vctOldDir);
	cd( scDrawUnits, NUMBER_OF_VARS, scStep, gfunc, 
          &(avctCDOtherLines[ROUND(sc)]), &vctOldDir, pvctOldCD, 
          &(avctCDDrawLines[k*DrawPoints]) );
#ifdef MOEBIUS
	fprintf(stderr, "%d\n", k);
	for (j = 0; j < 200; j++) {
	    if (fabs(avctCDDrawLines[k*DrawPoints + j].vars[0]) <= 0.1) {
		EvaluateParEqn( aeqnSurface, 
                  &(avctCDDrawLines[k*DrawPoints + j]), &vctMoebiusTemp );
		OutputPoint(stderr, &vctMoebiusTemp);
	    }
	}
#endif
    }
}

