/*
 *  Include file:  control
 *
 *  Program:  xdisp (X11 grahpics displayer for project Riemann)
 *
 *  Contents: This include file contains defintions pertaining to the control
 *	      window.  This include file includes the main xdisp include file.
 */

#include "xdisp.h"

/************************/
/* Constant definitions */
/************************/

#define SLIDER_BAR_WIDTH   150		/* Width of slider bar (in pixels) */
#define LEFT_BORDER	    10		/* Border widths (in pixels) on left */
#define RIGHT_BORDER	    10		/*   & right sides of control window */
#define BUTTON_BORDER	     3		/* Number of pixels that button box */
					/*   is outside from button text */
#define THETA_MIN	-180.0		/* Minimum & maximum values for theta */
#define THETA_MAX	 180.0		/*   slider bar */
#define ETA_MIN	        -180.0		/* Minimum & maximum values for eta */
#define ETA_MAX	 	 180.0		/*   slider bar */
#define TIC_HEIGHT_INC    0.15		/* Fraction of tic mark height used */
					/*   draw tic marks */


/********************/
/* Global variables */
/********************/

GLOBAL XFontStruct *pxfs;		/* Font structure used for all text */
GLOBAL int 	    ControlWindowWidth,	
		    ControlWindowHeight;
GLOBAL int          CheckBoxWidth;
GLOBAL int          CheckBoxHeight;
GLOBAL int          SliderBarWidth;
GLOBAL int          SliderBarHeight;
GLOBAL int          ButtonWidth;
GLOBAL int          ButtonHeight;

GLOBAL XPoint       xptTheta;	        /* Origins of the slider bar, */
GLOBAL XPoint       xptEta;	        /*   check box, and button */
GLOBAL XPoint	    xptDistance;        /*   controls in the control */
GLOBAL XPoint	    xptParallel;        /*   window */
GLOBAL XPoint	    xptConnect1;
GLOBAL XPoint	    xptConnect2;
GLOBAL XPoint	    xptPAR;
GLOBAL XPoint	    xptAutoRedraw;
GLOBAL XPoint	    xptEqnTitle;
GLOBAL XPoint	    xptRedraw;

GLOBAL char	   *sThetaLabel;        /* Labels for the controls */
GLOBAL char	   *sEtaLabel;
GLOBAL char	   *sDistanceLabel;
GLOBAL char	   *sParallelLabel;
GLOBAL char	   *sConnect1Label;
GLOBAL char	   *sConnect2Label;
GLOBAL char	   *sPARLabel;
GLOBAL char	   *sAutoRedrawLabel;
GLOBAL char	   *sEqnTitleLabel;
GLOBAL char	   *sRedrawLabel;

GLOBAL char	   *sThetaMinLabel;	/* Labels for minimum and maximum of */
GLOBAL char	   *sThetaMaxLabel;     /*   slider bars */
GLOBAL char	   *sEtaMinLabel;
GLOBAL char	   *sEtaMaxLabel;
GLOBAL char	   *sDistanceMinLabel;
GLOBAL char	   *sDistanceMaxLabel;

GLOBAL int 	    MaxSliderBarLabelWidth;	/* Maximum width (in pixels) */
GLOBAL int 	    MaxSliderBarMinLabelWidth;  /*   of various text lables */
GLOBAL int 	    MaxSliderBarMaxLabelWidth;
GLOBAL int 	    MaxCheckBoxLabelWidth;

GLOBAL BOOL	    bRedrawValid;		/* TRUE if valid to do redraw */
GLOBAL Window	    wnControl;
GLOBAL Window	    wnTheta, wnEta, wnDistance;
GLOBAL Window	    wnParallel, wnConnect1,
		    wnConnect2, wnPAR,
		    wnAutoRedraw, wnEqnTitle;
GLOBAL Window	    wnRedraw;
GLOBAL GC	    gcGray;		/* GC used to draw grayed text & */
					/*   graphics */
GLOBAL GC	    gcControl;	        /* GC used to draw ordinary control */
					/*   window text & graphics */

GLOBAL int	    FontAscent, FontDescent;
GLOBAL int	    InterlineSpacing;
GLOBAL int	    CharHeight;		/* Character height including */
					/*   interline spacing */
GLOBAL int	    TrueCharHeight;	/* Character height without */
					/*   interline spacing */
GLOBAL SCALAR	    scDistanceMin;	/* Minimum & maximum distance on */
GLOBAL SCALAR	    scDistanceMax;	/*   distance slider bar */


/**********/
/* Macros */
/**********/

/* MY_TEXT_WIDTH computes the width of the passed string using the standard */
/*   font (pointed to by pxfs) */
#define MY_TEXT_WIDTH(s) (XTextWidth(pxfs, s, strlen(s)))

