/*
 *  Include file:  master
 *
 *  Programs: all project Riemann programs
 *
 *  Contents: This include file contains defintions common to all of the project
 *  	      Riemann programs.
 */


#include <math.h> 				/* Standard include files */
#include <stdio.h>
#include <strings.h>


/************************/
/* Constant definitions */
/************************/

/* "mathbase" constant definitions */

/* Small number used for various things */
#define EPSILON	0.000001

/* Number of variables we are using (the dimension of the space) */
#define NUMBER_OF_VARS 3

/* Maximum number of directions used by ortho frame */
#define MAX_DIR 200

/* special constants taken from CRC Standard Mathematics Tables, 27th Edition */
#define E  2.71828182845904523536028747135266249775724790369996

/* If PI is not defined in math.h, define it */
#ifndef PI
#define PI 3.14159265358979323846264338327950288419716939937511
#endif

/* Types of output */
#define IMP_GEOD	1
#define IMP_CURV	2
#define PAR_GEOD	3
#define PAR_CURV	4

/* General constant definitions */
#define TRUE  			1
#define FALSE 			0
#define MAX_STRING_LENGTH     200	


/**********/
/* Macros */
/**********/

#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define ROUND(x) ((x) >= 0.0 ? ((int) ((x)+0.5)):((int) ((x)-0.5)))

/* Convenience macros for types */
#define	IS_GEODESICS(x)	      ((x) == IMP_GEOD || (x) == PAR_GEOD)
#define IS_CURVATURE_LINES(x) ((x) == IMP_CURV || (x) == PAR_CURV)
#define IS_IMPLICIT(x)	      ((x) == IMP_GEOD || (x) == IMP_CURV)
#define IS_PARAMETRIC(x)      ((x) == PAR_GEOD || (x) == PAR_CURV)


/************/
/* typedefs */
/************/

/* "mathbase" typedefs */

typedef short  EXPONENT;	/* An EXPONENT is just an integer */
typedef double SCALAR;		/* A SCALAR is just a double precision float */

typedef struct {		/* Define type for vector in n space */
    double vars[4];
    } VECTOR;

typedef VECTOR *PVECTOR;	/* Define pointer type to a vector */

typedef struct term {		/* Define type for term in polynomial */
    double   coef;		/* Coefficient of term */
    EXPONENT exps[NUMBER_OF_VARS]; /* Integral power of each variable */
    struct   term *ptrmNext; 	/* Pointer to next term in linked list */
} TERM;			

typedef TERM *PTERM;		/* Define pointer type to a term */

typedef struct tagPOLY {	/* Define type for polynomial */
    PTERM    ptrmFirst; 	/* Pointer to 1st term in polynomial */
    EXPONENT MaxDegree; 	/* Maximum degree of terms in poly */
				/*   (this is generally unused) */
} POLY;

typedef POLY *PPOLY;		/* Define pointer type to polynomial */

enum functions {
    F_NEG, F_ADD, F_SUB, F_MUL, F_DIV, F_POW, F_LN, F_INV, F_SQR, F_EXP, 
    F_SQRT, F_DBL, F_HALF, F_SIN, F_COS
};

enum nodetag {
    N_F, N_C, N_V
};

typedef struct expr {
    enum nodetag t;
    int ref;
    struct expr *partials[NUMBER_OF_VARS];
    union {
	SCALAR c;
	short  v;
	struct {
	    int f;
	    int n;
	    struct expr **a;
	} f;
    } x;
} EXPR;

typedef EXPR *PEXPR;

typedef enum {			/* Define enumerated type used to mark an */
    E_EXPR,			/*   equation as being either an expression */
    E_POLY			/*   or a polynomial */ 
} EQNTYPE;

typedef struct {		/* Define equation type; an equation can be */
    EQNTYPE et;			/*   either a polynomial or an expression */
    union {			
        PPOLY ppl;
	PEXPR pexp;
    } d;
} EQN;

typedef EQN *PEQN;		/* Define pointer to equation type */

typedef struct {		/* Define parametric equation type */
    EQNTYPE	et;
    union {
	PPOLY	ppl;
	PEXPR	pexp;
    } d[NUMBER_OF_VARS];
} PAREQN;

typedef	PAREQN	*PPAREQN;	/* Define pointer to parametric	*/
				/*   equation type */

/* General typedefs */

typedef int BOOL;		/* The boolean type is just an integer */


/*********************/
/* Function protypes */
/*********************/

/* "mathbase" function prototypes */
void    VctTimesSc();
void    VctPlusVct();
void	VctMinusVct();
SCALAR	VctDotVct();
void	Projection();
void	Reflection();
void	Normalize();
SCALAR  NbyDet();
void	VctCrossproduct();
void	ReadVct();
void	NegateVct();
void    PolyGradient();
SCALAR	EvaluatePoly();
PPOLY	PartialPoly();
PTERM	ReadTrm();
void	PrintPoly();
PTERM	CopyTrm();
PPOLY	CopyPoly();
void	NumGradient();
SCALAR	EvalNumPoly();
PPOLY	ParsePoly();
SCALAR  Power();
SCALAR  EvaluateExpr();
PEXPR   ReadExpr();
void    PrintExpr();
PEXPR   ParseExpr();
PEXPR	DisposeExpr();
PEXPR   ExprF1Node(), ExprF2Node(), ExprFnNode();
PEXPR   ExprVarNode(), ExprConstNode(), CopyExpr();
void    SimplifyExpr();
PEXPR   PartialExpr();
BOOL    EqualExpr();
SCALAR	EvaluateEqn();
PEQN	CopyEqn();
void	EqnGradient();
PEQN	PartialEqn();
void	RungeKutta();
SCALAR	simps();
void	computek();
PEQN    multeqn();
PPOLY   multpoly();
PEXPR   multexpr();
PEQN	addeqn();
PPOLY   addpoly();
PEXPR	addexpr();
PEQN	subeqn();
PEXPR   exprproduct();
PPOLY   polyproduct();
PEQN    vvfinnerproduct();
void    EvaluateParEqn();
PEQN	negateeqn();
PPOLY	negatepoly();
PEXPR	negateexpr();
char   *MyMalloc();
void	VctCopy();

/* User interface function prototypes */
void	UserInterface();
void	FatalExit();

/* Output function prototypes */
void	OutputHeader();
void	OutputPoint();
void	OutputLineStart();
void	Output2dPoint();

/* Polynomial parser function prototypes */
PPOLY	ParsePoly();

/* General function protypes */
#include <stdlib.h>
//char	*malloc();
//char	*alloca();

