/*
 *  Include file:  parsepoly
 *
 *  Library:  mathbase.a (project Riemann math routines)
 *
 *  Contents: This is the include file for the polynomial parsing routines.
 */

#include "master.h"


/************************/
/* Constant definitions */
/************************/

/* The token types */
#define	X_VAR_TYPE	0		/* Note that the variable types */	
#define Y_VAR_TYPE	1 		/*   correspond to indices in the */
#define Z_VAR_TYPE	2		/*   'exps' array in polynomials */
#define NUMBER_TYPE	10
#define END_TYPE	11		/* End of string */
#define	PLUS_TYPE	12
#define MINUS_TYPE	13
#define	CARET_TYPE	14


/***********************/
/* Function prototypes */
/***********************/

BOOL	ParseTerm();
BOOL	ParseCoefficient();
BOOL	ParseVariable();
BOOL	GetNextToken();

