/*
 *  Include file:  userinter
 *
 *  Programs: symgeod, numgeod, impcurv, and parcurv (project Riemann curvature
 *            lines and geodesics generators)
 *
 *  Contents: This include file contains defintions for all the user interfaces.
 */

#include "master.h"

#ifdef MAIN
#define GLOBAL
#else
#define GLOBAL extern
#endif


/************************/
/* Constant definitions */
/************************/

#define	DEF_GEOD_STEP		.1	/* Default step size for geodesics */
#define DEF_GEOD_ITERATIONS	30	/* Default number of iterations per */
					/*   geodesic */
#define	DEF_GEODESICS		15	/* Default number of geodesics */
#define	DEF_EQNTYPE         E_POLY      /* Default equation type */
#define DEF_CURV_STEP		.1	/* Default curvature line step size */
#define DEF_CURV_SPACING       1.0 	/* Default curv. line mesh spacing */
#define DEF_CURV_D1	      10.0	/* Default curv. line distance along */
#define DEF_CURV_D2	      10.0	/*   directions one and two */

/* Note: the default initial point is always (0, 0, 0, 0, ...) */


/********************/
/* Global variables */
/********************/

GLOBAL	char   sUsage[500];	/* String containing usage message */
GLOBAL	char   **GlobalArgv;	/* Global equivalents of argv and argc */
GLOBAL	int    GlobalArgc;


/***********************/
/* Function prototypes */
/***********************/

void 	Input();
EQNTYPE InputEqnType();
PPOLY  	InputPoly();
FILE    *InputOutputFile();
char    *InputTitle();
void    GetPointArg();
void    GetStepSizeArg();
void    GetIterationsArg();
void    GetGeodesicsArg();
PEXPR   InputExpr();
void	GetD1Arg();
void	GetD2Arg();
void	GetSpacingArg();
void	InteractiveInput();
void	ProcessArgs();
void	GetExprArg();
void	GetPolyArg();

