/*
 *  Include file:  xdisp
 *
 *  Program: xdisp (X11 grahpics displayer for project Riemann)
 *
 *  Contents: This is the main include file for the xdisp program.
 */

#include "master.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <ctype.h>
#include <strings.h>

#ifdef MAIN
#define GLOBAL
#else
#define GLOBAL extern
#endif

/************************/
/* Constant definitions */
/************************/

#define MAX_POINTS 	       20000  /* Maximum number of points in one line */
#define DEFAULT_PICTURE_WIDTH	500  /* Default picture window size */
#define DEFAULT_PICTURE_HEIGHT  500


/********************/
/* Type definitions */
/********************/

typedef unsigned long Pixel;

typedef struct {
    SCALAR x, y, z;
    } POINT;

typedef POINT * PPOINT;	

typedef struct tagLINE {	/* LINEs are lists of points, each */
 				/*   connected to the next */
    int	           length;	/* Number of points on line */
    int		   direction;   /* 1 or 2; used to record direction of */
                                /*   curvature lines */
    PPOINT         papt; 
    struct tagLINE *plnNext;
    } LINE;

typedef LINE * PLINE;

typedef struct {			/* SURFACEs consist of several lines */
    int		type;			/* Implicit geodesics, etc. */
    BOOL	bParSpace;		/* TRUE if points in parameter space */
    char	*sTitle;
    char	*sCreated;		/* Date & time from data file */
    EQNTYPE	et;			/* Equation type */
    char	*sEquation1;		/* Equations from data file */
    char	*sEquation2;
    char	*sEquation3;
    SCALAR	XMin, YMin, ZMin;	/* Minimum and maximum coordinates */
    SCALAR	XMax, YMax, ZMax;	/*   over all points */
    SCALAR	scSurfaceSize;		/* Distance between furthest corners */
					/*   of surrounding right rectangular */
					/*   prism of surface */
    int		LineCount;		/* Number of lines in surface */
    PLINE	plnFirst;
    } SURFACE;

typedef SURFACE * PSURFACE;


/********************/
/* Global variables */
/********************/

GLOBAL char        *sProgramName;
GLOBAL Display     *pds;
GLOBAL GC           gcPicture;
GLOBAL Colormap     cm;
GLOBAL int	    screen;
GLOBAL Window	    wnPicture;
GLOBAL Pixel	    pxlColor1, 		    /* Color of curvature lines in */
		    pxlColor2, 		    /*   direction 1 & 2 */
		    pxlColorG, 		    /* Color of geodesics */
		    pxlBackground;	    /* Background color */

GLOBAL BOOL	    bConnect1, bConnect2;   /* If TRUE, connect 1st and last */
					    /*   points of curv. lines going */
					    /*   in direction 1 or 2 */
GLOBAL BOOL	    bParallel;		    /* TRUE if parallel projection */
GLOBAL BOOL	    bPAR;		    /* TRUE if user wishes to */
					    /*   preserve aspect ratio */
GLOBAL BOOL	    bAutoRedraw;	    /* TRUE if user wishes picture to */
					    /*   be redrawn whenever a */
				            /*   parameter is changed */
GLOBAL BOOL	    bEqnTitle;		    /* TRUE if user wishes equation */
					    /*   to be title of picture */
					    /*   window */

GLOBAL POINT	    VRP;		 /* View reference point--point that */
					 /*   the viewer looks at (contained */
					 /*   in the projection plane) */
GLOBAL BOOL         bDebug;              /* TRUE when debugging on */
GLOBAL BOOL         bVerbose;            /* TRUE when user wishes verbose */
					 /*   information to be output */
GLOBAL BOOL	    bNoDraw;             /* TRUE when don't draw surface */
GLOBAL BOOL	    bUSDistance;	 /* TRUE if user specifies distance */
					 /*   on command line or in resource */
					 /*   database */

/* For scTheta and scEta descriptions, p is the vector <COP, VRP> */
GLOBAL SCALAR	    scTheta;		/* Angle p is from positive x axis */
					/*   (90 degrees = pos. y axis) */
GLOBAL SCALAR	    scEta;		/* Angle p is from xy plane */
					/*   (90 degrees = pos. z axis) */

GLOBAL SCALAR	    scD;		/* Distance of COP (observer) from */
					/*   projection plane */
GLOBAL SCALAR	    T[4][4];		/* Transformation matrix */
GLOBAL Pixel	    pxlBlack, pxlWhite;
GLOBAL int 	    PictureWindowWidth,
                    PictureWindowHeight;
GLOBAL int 	    PictureBorderWidth;	/* Width of inside border (in pixels) */
					/*   around the projected surface */
GLOBAL Pixmap       pxSurface;		/* Pixmap copy of picture window */
GLOBAL char	   *sEqnTitle;          /* Equation string used in title bar */
					/*   for picture window */

GLOBAL char	   **GlobalArgv;       	/* Global equivalent of argv */


/*********************/
/* Macro definitions */
/*********************/

/* This macro fills in 4 by 4 matrices */
#define FILL4x4(A, e00, e01, e02, e03,                                                             e10, e11, e12, e13,                                                             e20, e21, e22, e23,                                                             e30, e31, e32, e33) \
       { A[0][0] = (e00); A[0][1] = (e01); A[0][2] = (e02); A[0][3] = (e03);\
	 A[1][0] = (e10); A[1][1] = (e11); A[1][2] = (e12); A[1][3] = (e13);\
	 A[2][0] = (e20); A[2][1] = (e21); A[2][2] = (e22); A[2][3] = (e23);\
	 A[3][0] = (e30); A[3][1] = (e31); A[3][2] = (e32); A[3][3] = (e33); }


/***********************/
/* Function prototypes */
/***********************/

void      FatalExit();
void	  ReadSurface();
void      DrawSurface();
void	  MakeSurfacePixmap();
Pixel	  AllocNamedColor();
void	  MultiplyMatrices();
BOOL	  ComputeTransformMatrix();
void	  DrawControlWindow();
void	  InitializeControlWindow();
void	  DrawSliderBar();
void	  DrawControlWindow();
void	  DrawCheckBox();
void	  DrawButton();
void	  HandleButtonPress();
SCALAR	  SliderBarInput();
void	  InitializePictureWindow();
void	  RedrawSurface();
void	  PrintMatrix();
void	  DrawThetaSliderBar();
void	  DrawEtaSliderBar();
void	  DrawDistanceSliderBar();
void	  DrawParallelCheckBox();
void	  DrawConnect1CheckBox();
void	  DrawConnect2CheckBox();
void	  DrawPARCheckBox();
void	  DrawAutoRedrawCheckBox();
void	  DrawEqnTitleCheckBox();
void	  DrawRedrawButton();
void	  DumpSurface();
void	  ProcessOptions();
BOOL	  MyGeometry();
void	  CreateControlWindow();

