/*
 *  Module:   equation add
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:  addeqn
 *
 *   Purpose:   This function adds the two passed equations and returns
 *              the sum equation.  The two equations must be both polynomials
 *		or both expressions.
 *
 *   Author:    Jim Lambers
 *
 */

PEQN	addeqn(peqn1, peqn2)
PEQN	peqn1, peqn2;
{
    PEQN	peqnSum;


    peqnSum = (PEQN) MyMalloc(sizeof(EQN));
    peqnSum->et = peqn1->et;

    if (peqn1->et == E_POLY)
	peqnSum->d.ppl = addpoly(peqn1->d.ppl, peqn2->d.ppl);
    else
	peqnSum->d.pexp = ExprF2Node(F_ADD, peqn1->d.pexp, peqn2->d.pexp);

    return(peqnSum);
}

