/*
 *  Module:   equation copy
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	CopyEqn
 *
 *   Purpose:	This function makes a copy of the passed equation and returns
 *		this copy. 
 *
 *   Author:    Bret Johnson
 *
 */

PEQN	CopyEqn(peqn)
PEQN	peqn;
{
    PEQN    peqnCopy;


    peqnCopy = (PEQN) MyMalloc(sizeof(EQN));
    peqnCopy->et = peqn->et;

    if (peqn->et == E_POLY)
        peqnCopy->d.ppl = CopyPoly(peqn->d.ppl);
    else
        peqnCopy->d.pexp = CopyExpr(peqn->d.pexp);

    return peqnCopy;
}


