/*
 *  Module:   equation evaluate
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	EvaluateEqn
 *
 *   Purpose:	This function evaluates the equation *peqn at the point *pvctPt
 *		and returns the result of the evaluation.
 *
 *   Author:    Bret Johnson
 */

SCALAR	EvaluateEqn(peqn, pvctPt)
PEQN	peqn;
PVECTOR	pvctPt;
{
    if (peqn->et == E_POLY)
	return(EvaluatePoly(peqn->d.ppl, pvctPt));
    return(EvaluateExpr(peqn->d.pexp, pvctPt));
}

