/*
 *  Module:   equation gradient
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	EqnGradient
 *
 *   Purpose:	This function returns the gradient at point pvctPoint of the 
 *		equation whose partial derivatives are stored in apeqnPartials.
 *		apeqnPartials must be an array of pointers to equations, those
 *		equations being the partial derivatives of the original equation
 *		with respect to every variable.
 *
 *   Author:    Bret Johnson
 *
 */

void	EqnGradient(apeqnPartials, pvctPt, pvctGradient)
PEQN	apeqnPartials[NUMBER_OF_VARS];  
PVECTOR	pvctPt; 			
PVECTOR	pvctGradient;
{
    short	i;

    for (i = 0; (i < NUMBER_OF_VARS); i++) 
        pvctGradient->vars[i] = EvaluateEqn(apeqnPartials[i], pvctPt);
}

