/*
 *  Module:   equation multiply
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:  multeqn
 *
 *   Purpose:   This function multiplies the two passed equations and returns
 *              the product equation.  The two equations must be both
 *		polynomials or both expressions.
 *
 *   Author:    Bret Johnson
 *
 */

PEQN	multeqn(peqn1, peqn2)
PEQN	peqn1, peqn2;
{
    PEQN	peqnProduct;


    peqnProduct = (PEQN) MyMalloc(sizeof(EQN));
    peqnProduct->et = peqn1->et;

    if (peqn1->et == E_POLY)
	peqnProduct->d.ppl = multpoly(peqn1->d.ppl, peqn2->d.ppl);
    else
	peqnProduct->d.pexp = ExprF2Node(F_MUL, peqn1->d.pexp, peqn2->d.pexp);

    return(peqnProduct);
}

