/*
 *  Module:   equation partial
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	PartialEqn
 *
 *   Purpose:	This function computes the partial derivative of the passed
 *		equation.  
 *
 *   Author:    Bret Johnson
 *
 */

PEQN	PartialEqn(peqn, var)
PEQN	peqn;
short	var;
{
    PEQN peqnTemp;


    peqnTemp = CopyEqn(peqn);

    if (peqn->et == E_POLY)
	peqnTemp->d.ppl = PartialPoly(peqnTemp->d.ppl, var);
    else
	peqnTemp->d.pexp = PartialExpr(peqnTemp->d.pexp, var); 

    return peqnTemp;
}

