/*
 *  Module:   evaluate parametric equation
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:  EvaluateParEqn
 *
 *   Purpose:   This function evaluates the system of three parametric
 *              equations passed via the array apeqn at the two parameters 
 *              passed via pvct.  The resulting three values are returned via
 *		pvctResult.  The two parameters should be stored in the first
 *		two array locations (the x and y locations) of *pvct.
 *
 *   Author:    Jim Lambers
 *
 */

void	EvaluateParEqn(apeqn, pvct, pvctResult)
PEQN	apeqn[3];
PVECTOR	pvct, pvctResult;
{
    int		i;


    for (i = 0; i < 3; i++) {
	if (apeqn[i]->et == E_POLY)
	    pvctResult->vars[i] = EvaluatePoly(apeqn[i]->d.ppl, pvct);
	else pvctResult->vars[i] = EvaluateExpr(apeqn[i]->d.pexp, pvct);
    }
}

