/*
 *  Module:   expression node
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

struct epool {
    EXPR		e[sizeof(unsigned)*8];
    unsigned		m;
    struct epool	*n;
} *epool;

PEXPR NewExpr()
{
    struct epool 	**h, *t;
    int 		i;
    unsigned		m;

    h = &epool;
    while (*h && !~(*h)->m) h = &((*h)->n);
    if (!*h) {
	t = (struct epool *) MyMalloc(sizeof(struct epool));
	t->n = NULL;
	t->m = 0;
	*h = t;
    }
    m = (*h)->m;
    for (i = 0; m&1; i++) m>>=1;
    (*h)->m |= 1<<i;
    return(&((*h)->e[i]));
}

struct pepool {
    PEXPR		pe[sizeof(unsigned)*8];
    unsigned		m;
    struct pepool	*n;
} *pepool;

PEXPR	*NewPexpr(n)
int	n;
{
    struct pepool	**h, *t;
    int			i;
    unsigned		m, m1;

    if (n > sizeof(unsigned) * 8) exit(1);  /* can't deal with this */
    h = &pepool;
    while (*h && !~(*h)->m) 
      search:
	h = &((*h)->n);
    if (!*h) {
	t = (struct pepool *) MyMalloc(sizeof(struct pepool));
	t->n = NULL;
	t->m = 0;
	*h = t;
    }
    m = (*h)->m;
    m1 = (1<<n)-1;
    for (i = 0; m&m1; i++) m>>=1;
    if (i+n > sizeof(unsigned)*8) goto search;
    (*h)->m |= m1<<i;
    return(&((*h)->pe[i]));
}

PEXPR DisposeExpr(pexp_e)
PEXPR pexp_e;
{
    int			i;
    unsigned		m;
    struct epool	*h;
    struct pepool	*ph;

    if (pexp_e->t == N_F && !--pexp_e->ref) {
	for (i = 0; i < NUMBER_OF_VARS; i++)
	    if (pexp_e->partials[i])
		DisposeExpr(pexp_e->partials[i]);
	for (i = 0; i < pexp_e->x.f.n; i++)
	    DisposeExpr(pexp_e->x.f.a[i]);
	if (pexp_e->x.f.n) {
	    ph = pepool;
	    m = (1<<pexp_e->x.f.n) - 1;
	    while (ph) {
		i = (pexp_e->x.f.a - ph->pe);
		if (i >= 0 && i < sizeof(unsigned) * 8) {
		    ph->m &= ~(m<<i);
		    break;
		}
		ph = ph->n;
	    }
	}
	h = epool;
	while (h) {
	    i = (pexp_e - h->e);
	    if (i >= 0 && i < sizeof(unsigned) * 8) {
		h->m &= ~(1<<i);
		break;
	    }
	    h = h->n;
	}
    }
}

PEXPR	ExprF2Node (func, a1, a2)
int	func;
PEXPR	a1, a2;
{
    PEXPR t;
    int i;

    t = NewExpr();
    t->t = N_F;
    t->ref = 1;
    for (i = 0; i < NUMBER_OF_VARS; i++) t->partials[i] = NULL;
    t->x.f.f = func;
    t->x.f.n = 2;
    t->x.f.a = NewPexpr(2);
    t->x.f.a[0] = a1;
    t->x.f.a[1] = a2;
    return(t);
}

PEXPR	ExprF1Node (func, a)
int	func;
PEXPR	a;
{
    PEXPR t;
    int i;

    t = NewExpr();
    t->t = N_F;
    t->ref = 1;
    t->x.f.n = 1;
    for (i = 0; i < NUMBER_OF_VARS; i++) t->partials[i] = NULL;
    t->x.f.f = func;
    t->x.f.a = NewPexpr(1);
    t->x.f.a[0] = a;
    return(t);
}

PEXPR	ExprFnNode (func, n, aa)
int	func, n;
PEXPR	*aa;
{
    PEXPR	t;
    int		i;
    
    t = NewExpr();
    t->t = N_F;
    t->ref = 1;
    for (i = 0; i < NUMBER_OF_VARS; i++) t->partials[i] = NULL;
    t->x.f.n = n;
    t->x.f.f = func;
    t->x.f.a = NewPexpr(n);
    for (i = 0; i < n; i++)
	t->x.f.a[i] = aa[i];
    return(t);
}

PEXPR vnl[NUMBER_OF_VARS];

PEXPR	ExprVarNode(var)
short	var;
{
    int		i;
    
    if (!vnl[var]) {
	vnl[var] = NewExpr();
	vnl[var]->t = N_V;
	vnl[var]->ref = 1;
	for (i = 0; i < NUMBER_OF_VARS; i++) 
	  vnl[var]->partials[i] = ExprConstNode((i == var) ? 1.0 : 0.0);
	vnl[var]->x.v = var;
    }
    return(vnl[var]);
}

struct cnl {
    double	v;
    PEXPR	e;
    struct cnl	*n;
} *cnl_head = NULL;

struct cnl_pool {
    struct cnl		c[64];
    int			hi;
    struct cnl_pool	*n;
} *cnl_pool = NULL;
/****************************************************************************
 *   Comment by S. Tuohy                                                    *
 * on attempting to compile this program on "deslab", found that            *
 * using "const" as a variable name cause a syntax error that               *
 * prevented further compilation, changed the variable name to "myconst"    *
 * and achieved successul compilation!                                      *
 ****************************************************************************/

PEXPR ExprConstNode(myconst)
SCALAR myconst;
{
    int		i;
    struct cnl	**h, *t;
    
    h = &cnl_head;
    while (*h && (*h)->v < myconst) h = &((*h)->n);
    t = *h;
    if (!t || t->v != myconst) {
	struct cnl_pool **ch, *ct;
	ch = &cnl_pool;
	while (*ch && (*ch)->hi == 64) ch = &((*ch)->n);
	if (!*ch) {
	    ct = (struct cnl_pool *) MyMalloc(sizeof(struct cnl_pool));
	    ct->n = NULL;
	    ct->hi = 0;
	    *ch = ct;
	}
	t = &((*ch)->c[(*ch)->hi++]);
	t->n = *h;
	*h = t;
	t->v = myconst;
	t->e = NewExpr();
	t->e->t = N_C;
	t->e->ref = 1;
	t->e->x.c = myconst;
	for (i = 0; i < NUMBER_OF_VARS; i++)
	    t->e->partials[i] = ExprConstNode(0.0);
      }
    return(t->e);
}


