/*
 *  Module:   expression partial
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"
    
#define ADD(a,b) ExprF2Node(F_ADD,(a),(b))
#define SUB(a,b) ExprF2Node(F_SUB,(a),(b))
#define MUL(a,b) ExprF2Node(F_MUL,(a),(b))
#define DIV(a,b) ExprF2Node(F_DIV,(a),(b))
#define POW(a,b) ExprF2Node(F_POW,(a),(b))
#define SQR(a)   ExprF1Node(F_SQR,(a))
#define SQRT(a)  ExprF1Node(F_SQRT(a))
#define LN(a)    ExprF1Node(F_LN,(a))
#define NEG(a)   ExprF1Node(F_NEG,(a))
#define DBL(a)   ExprF1Node(F_DBL,(a))
#define HALF(a)  ExprF1Node(F_HALF,(a))
#define INV(a)   ExprF1Node(F_INV,(a))
#define X(n)     CopyExpr(a[(n)])
#define P(n)     PartialExpr(a[(n)],var)
#define C(n)     ExprConstNode((n))
#define SIN(a)   ExprF1Node(F_SIN,(a))
#define COS(a)   ExprF1Node(F_COS,(a))

/*
 *   Function:	PartialExpr
 *
 *   Purpose:	This function computes the partial derivative of the passed
 *		expression.  
 *
 *   Author:    Scott Goehring
 *
 */

PEXPR	PartialExpr(pexp, var)
PEXPR	pexp;
short	var;
{
    PEXPR *a;
    PEXPR d;

    if (pexp->partials[var]) 
	return CopyExpr(pexp->partials[var]);
    switch (pexp->t) {
      case N_C:
	d = C(0.0);
	break;
      case N_V:
	d = C((pexp->x.v == var)?1.0:0.0);
	break;
      case N_F:
	a = pexp->x.f.a;
	switch(pexp->x.f.f) {
	  case F_NEG:
	    d = ExprF1Node(F_NEG,P(0));
	    break;
	  case F_ADD:
	    d = ADD(P(0),P(1));
	    break;
	  case F_SUB:
	    d = SUB(P(0),P(1));
	    break;
	  case F_MUL:
	    d = ADD(MUL(X(0),P(1)),MUL(X(1),P(0)));
	    break;
	  case F_DIV:
	    d = SUB(DIV(P(0),X(1)),DIV(MUL(P(1),X(0)),SQR(X(1))));
	    break;
	  case F_POW:
	    d = ADD(MUL(POW(X(0),SUB(X(1),C(1.0))),MUL(X(1),P(0))),
		    MUL(CopyExpr(pexp),MUL(P(1),LN(X(0)))));
	    break;
	  case F_LN:
	    d = DIV(P(0),X(0));
	    break;
	  case F_INV:
	    d = NEG(DIV(P(0),SQR(X(0))));
	    break;
	  case F_SQR:
	    d = DBL(MUL(X(0),P(0)));
	    break;
	  case F_EXP:
	    d = MUL(CopyExpr(pexp),P(0));
	    break;
	  case F_SQRT:
	    d = MUL(HALF(INV(CopyExpr(pexp))),P(0));
	    break;
	  case F_DBL:
	    d = DBL(P(0));
	    break;
	  case F_HALF:
	    d = HALF(P(0));
	    break;
	  case F_SIN:
	    d = MUL(P(0),COS(X(0)));
	    break;
	  case F_COS:
	    d = MUL(P(0),NEG(SIN(X(0))));
	    break;
	}
    }
    SimplifyExpr(&d);
    return CopyExpr(pexp->partials[var]=d);
}


