/*
 *  Module:   expression print
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"
#include <ctype.h>

/*
 *   Function:	PrintExpr
 *
 *   Purpose:	This function prints a expression to standard output.
 *
 *   Author:    Scott Goehring
 *
 */

void	PrintExpr(pexp_e)
    PEXPR pexp_e;
{
    char *cp;
    int n;
    static char *exprfmts[] = {
	"(-%0)",
	"(%0+%1)",
	"(%0-%1)",
	"(%0*%1)",
	"(%0/%1)",
	"(%0^%1)",
	"(ln %0)",
	"(1/%0)",
	"(%0^2)",
	"(e^%0)",		/* Used to be (e^x), but this seemed wrong */
	"(sqrt %0)",		/* Used to be (x^0.5), but this seemed wrong */
	"(2*%0)",		/* Used to be (2*x), but this seemed wrong */
	"(%0/2)",		/* Used to be (x/2), but this seemed wrong */
	"(sin %0)",
	"(cos %0)"
	};
    switch (pexp_e->t) {
      case N_C:
	printf ("%g", pexp_e->x.c); break;
      case N_V:
	putchar (pexp_e->x.v+'x'); break;
      case N_F:
	for(cp=exprfmts[pexp_e->x.f.f];*cp;cp++)
	    if (*cp!='%') putchar(*cp);
	    else {
		n=0;
		while(isdigit(*++cp)) n=n*10+*cp-'0';
		cp--;
		PrintExpr(pexp_e->x.f.a[n]);
	    }
	break;
    }
}

