/*
 *  Module:   expression read
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "parse_expr.h"
#include <string.h>
#include <stdlib.h>

/*
 *   Function:	ReadExpr
 *
 *   Purpose:	This function reads in a expression as a string and
 *              then calls ParseExpr (the interface to the YACC-based
 *              expression parser) to convert it to an expression
 *              tree.  If the string is grammatically incorrect, NULL is 
 *		returned.  This function also returns, via the variable 
 *		parameter psExpr, the string representation of the expression
 *		if it is valid.
 *
 *   Author:    Scott Goehring
 *
 */

PEXPR	ReadExpr(pfInfile, psExpr)
FILE	*pfInfile;
char	**psExpr;
{
    char *str;
    PEXPR t;
    unsigned sz, ofs;

//    char *realloc();

    str=(char *) MyMalloc(sz=129);
    ofs=0;
    while(1) {
	fgets(str+ofs,129,pfInfile);
	if (str[strlen(str) - 1]=='\n') break;
	ofs+=128;
	str=realloc(str,sz+=128);
    }
    str[strlen(str) - 1]='\0';

    *psExpr = str;
    
    t = ParseExpr(str);
    if (t == NULL) {
        free(str);
	return NULL;	
    }
    SimplifyExpr(&t);
    return t;
}

