/*
 *  Module:   expression test
 *
 *  Library:  mathbase.a (project Riemann math routines)
 *  
 *  Author:   Scott Goehring
 *
 *  Purpose:  This routine is used to test the expression parser, the 
 *            expression printer, the expression differentiater, and the
 *	      expression simplifier.  This routine reads an expression from
 *	      standard input and outputs the expression as entered, the 
 *	      simplified expression, and the all of the expression's 1st 
 *	      through 4th partial derivatives.  Note that the output is 
 *	      lengthy, so it is best to redirect it to a file.
 */

#include "master.h"

main()
{
    PEXPR x, dx[3], ddx[3][3], dddx[3][3][3], ddddx[3][3][3][3];
    int v1, v2, v3, v4;
    char *sExpression;


    x = ReadExpr(stdin, &sExpression);
    if (x == NULL) {
	fprintf(stderr, "exprtest: Illegal expression\n"); 
	exit(1);
    }

    for (v1=0; v1<3; v1++) {
	dx[v1] = PartialExpr(x,v1);
	for (v2=0; v2<3; v2++) {
	    ddx[v1][v2] = PartialExpr(dx[v1],v2);
	    for (v3=0; v3<3; v3++) {
		dddx[v1][v2][v3] = PartialExpr(ddx[v1][v2],v3);
		for (v4=0; v4<3; v4++) {
		    ddddx[v1][v2][v3][v4] = PartialExpr(dddx[v1][v2][v3],v4);
		}
	    }
	}
    }

    printf("Entered expression: %s\n", sExpression);
    printf("Simplified expression: ");
    PrintExpr(x);

    printf("\nFirst partials:");
    for (v1=0; v1<3; v1++) {
	printf("\n%c    ",v1+'x');
	PrintExpr(dx[v1]);
    }
    printf("\nSecond partials:");
    for(v1=0; v1<3; v1++) {
	for (v2=0; v2<3; v2++) {
	    printf("\n%c%c  ", v1+'x', v2+'x');
	    PrintExpr(ddx[v1][v2]);
	}
    }
    printf("\nThird partials:");
    for(v1=0; v1<3; v1++) {
	for(v2=0; v2<3; v2++) {
	    for(v3=0; v3<3; v3++) {
		printf("\n%c%c%c  ", v1+'x', v2+'x', v3+'x');
		PrintExpr(dddx[v1][v2][v3]);
	    }
	}
    }
    printf("\nFourth partials:");
    for(v1=0; v1<3; v1++) {
	for(v2=0; v2<3; v2++) {
	    for(v3=0; v3<3; v3++) {
		for(v4=0; v4<3; v4++) {
		    printf("\n%c%c%c%c ", v1+'x', v2+'x', v3+'x', v4+'x');
		    PrintExpr(ddddx[v1][v2][v3][v4]);
		}
	    }
	}
    }
    putchar('\n');
}

