/*
 *  Module:   expression test 2
 *
 *  Library:  mathbase.a (project Riemann math routines)
 *  
 *  Author:   Jim Lambers
 *
 *  Purpose:  This routine is used to test the expression parser, the 
 *            expression printer, the expression simplifier, and the expression
 *	      evaluator.  This routine reads an expression from standard input
 *	      and outputs the expression as entered, the simplified expression,  *	      and the result of evaluating the expression at the point 
 *	      (1, 2, 3).
 */

#include "master.h"

main()
{
    PEXPR   x;
    VECTOR  y;
    SCALAR  z;
    char    *sExpression;


    x = ReadExpr(stdin, &sExpression);

    if (x == NULL) {
	fprintf(stderr, "exprtest2: Illegal expression\n"); 
	exit(1);
    }
     
    y.vars[0] = 1.0;
    y.vars[1] = 2.0;
    y.vars[2] = 3.0;
    z = EvaluateExpr(x, &y);
    printf("Entered expression: %s\n", sExpression);
    printf("Simplified expression: ");
    PrintExpr(x);
    printf("\n");
    printf("%lf\n", z);
}

