/*
 *  Module:   my malloc
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	MyMalloc
 *
 *   Purpose:	This function mallocs Bytes bytes and returns a pointer to the
 *		allocated block.  If an error occurs (i.e., no more memory), 
 *		this routine fatal exits.
 *
 *   Author:    Bret Johnson
 */

char  * MyMalloc(Bytes)
unsigned	Bytes;
{
    char   * pReturn;


    pReturn = malloc(Bytes);

    if (pReturn == NULL) {
	fprintf(stderr, "Cannot allocate %u bytes of memory\n", Bytes);
	exit(1);
    }
    else return pReturn;
}

