%{
/*
 *  Lex file: parse expression
 *
 *  Library: mathbase.a (project Riemann math routines)
 *
 *  Contents: This is the lex source for the expression parser.
 */

#include "parse_expr.h"
#include "parse_expr_y.h"
#include <ctype.h>

#undef input
#undef output
#undef unput

#define YY_NO_INPUT 1
extern char *ParseExpr_text;
static int input(void) {
    while (isspace(*pc_pexpr)) pc_pexpr++;
    return *pc_pexpr++;
}

#define output(c) 
#define unput(c) (*--pc_pexpr=(c))

ParseExpr_wrap() {return 1;}
%}

%%

[0-9]+(\.[0-9]+)?	{ ParseExpr_lval.cval = atof(ParseExpr_text); 
			  return CONST; }

ln			{ ParseExpr_lval.fval = F_LN; return FUNC; }
sin			{ ParseExpr_lval.fval = F_SIN; return FUNC; }
cos			{ ParseExpr_lval.fval = F_COS; return FUNC; }
sqrt			{ ParseExpr_lval.fval = F_SQRT; return FUNC; }

e			{ ParseExpr_lval.cval = E; return CONST; }
pi			{ ParseExpr_lval.cval = PI; return CONST; }

[x-z]			{ ParseExpr_lval.vval = *ParseExpr_text-'x'; 
			  return VAR; }

[s-t]			{ ParseExpr_lval.vval = *ParseExpr_text-'s'; 
			  return VAR; }

.			{ return *ParseExpr_text; }
%%

