/*
 *  YACC file: parse expression
 *
 *  Library: mathbase.a (project Riemann math routines)
 *
 *  Contents: This is the YACC source for the expression parser.
 */

%{
#include <stdio.h>
#include "parse_expr.h"
%}

%union ParseExpr_union {
    double cval;
    int    vval;
    int    fval;
    PEXPR  eval;
}

%start start

%token <cval> CONST
%token <fval> FUNC
%token <fval> FUNC2
%token <vval> VAR

%type <eval> exp
%type <eval> start

%left '+' '-'
%left '*' '/'
%right '^'
%left FUNC FUNC2
%left UMINUS 

%%

start	: exp				{ pexp_res = $$; }
	;

exp	: '(' exp ')'			{ $$ = $2; }
	| exp '+' exp			{ $$ = ExprF2Node (F_ADD, $1, $3 ); }
	| exp '-' exp			{ $$ = ExprF2Node (F_SUB, $1, $3 ); }
	| exp '*' exp			{ $$ = ExprF2Node (F_MUL, $1, $3 ); }
	| exp '/' exp			{ $$ = ExprF2Node (F_DIV, $1, $3 ); }
	| exp '^' exp			{ $$ = ExprF2Node (F_POW, $1, $3 ); }
	| FUNC exp			{ $$ = ExprF1Node ($1, $2); }
	| FUNC2 '(' exp ',' exp ')' 	{ $$ = ExprF2Node ($1, $3, $5); }
	| '-' exp	%prec UMINUS	{ $$ = ExprF1Node (F_NEG, $2, NULL); }
	| '+' exp	%prec UMINUS	{ $$ = $2; }
	| VAR				{ $$ = ExprVarNode ($1); }
	| CONST				{ $$ = ExprConstNode ($1); }
	;
%%

