/*
 *  Module:   polynomial add
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:  addpoly
 *
 *   Purpose:   This function adds the two passed polynomials and returns
 *              the sum polynomial.
 *
 *   Author:    Jim Lambers
 *
 */

PPOLY	addpoly(ppl1, ppl2)
PPOLY	ppl1, ppl2;
{
    PPOLY	pplSum;
    PTERM	ptrm, ptrm1, ptrm2;
    int		i;


    pplSum = (PPOLY) MyMalloc(sizeof(POLY));

    ptrm = pplSum->ptrmFirst = (PTERM) MyMalloc(sizeof(TERM));
    for (ptrm1 = (CopyPoly(ppl1))->ptrmFirst; ptrm1; ptrm1 = ptrm1->ptrmNext) {
	ptrm->coef = ptrm1->coef;
	for (i = 0; i < 3; i++)
	    ptrm->exps[i] = ptrm1->exps[i];
	ptrm = ptrm->ptrmNext = (PTERM) MyMalloc(sizeof(TERM));
    }

    for (ptrm2 = (CopyPoly(ppl2))->ptrmFirst; ptrm2; ptrm2 = ptrm2->ptrmNext) {
	ptrm->coef = ptrm2->coef;
	for (i = 0; i < 3; i++)
	    ptrm->exps[i] = ptrm2->exps[i];
	ptrm = ptrm->ptrmNext = (PTERM) MyMalloc(sizeof(TERM));
    }

    return(pplSum);
}

