/*
 *  Module:   polynomial copy
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	CopyTerm
 *
 *   Purpose:	This function recursively copies the terms of a polynomial
 *		whose first term is given.
 *
 *   Author:    Jim Lambers
 *
 */

PTERM	CopyTerm(ptrmOriginal)
PTERM	ptrmOriginal;
{
    PTERM		ptrmCopy;
    short		i;


    if (ptrmOriginal != NULL) {
	ptrmCopy = (PTERM) MyMalloc(sizeof(TERM));
	ptrmCopy->coef = ptrmOriginal->coef;
	for (i = 0; (i < NUMBER_OF_VARS); i++)
	    ptrmCopy->exps[i] = ptrmOriginal->exps[i];
	ptrmCopy->ptrmNext = CopyTerm(ptrmOriginal->ptrmNext);
	return(ptrmCopy);
    }
    else return(NULL);
}



/*
 *   Function:	CopyPoly
 *
 *   Purpose:	This function calls CopyTerm to duplicate the terms of
 *		the given polynomial.
 *
 *   Author:    Jim Lambers
 *
 */

PPOLY	CopyPoly(ppl)
PPOLY	ppl;
{
    PPOLY		pplCopy;


    pplCopy = (PPOLY) MyMalloc(sizeof(POLY));
    pplCopy->MaxDegree = ppl->MaxDegree;
    pplCopy->ptrmFirst = CopyTerm(ppl->ptrmFirst);

    return pplCopy;
}

