/*
 *  Module:   polynomial evaluate
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	EvaluatePoly
 *
 *   Purpose:	This function evaluates the polynomial *ppl at point *pvctPt
 *		and returns the result of the evaluation.
 *
 *   Author:    Lambers
 */

SCALAR	EvaluatePoly(pplEqn, pvctPt)
PPOLY	pplEqn;
PVECTOR	pvctPt;
{
    SCALAR 	scTermResult, scResult;
    short 	i, j;
    PTERM	ptrmCopy;


    scResult = 0;
    ptrmCopy = pplEqn->ptrmFirst;
    while (ptrmCopy != NULL) {
	scTermResult = ptrmCopy->coef;
	for (i = 0; (i < NUMBER_OF_VARS); i++)
	    for (j = 0; (j < ptrmCopy->exps[i]); j++)
		scTermResult *= pvctPt->vars[i];
	scResult += scTermResult;
	ptrmCopy = ptrmCopy->ptrmNext;
    }
    return(scResult);
}

