/*
 *  Module:   polynomail partial
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	PartialPoly
 *
 *   Purpose:	This function computes the partial derivative of the passed
 *		polynomial.  It is destructive to the polynomial.
 *
 *   Author:    Bret Johnson / Jim Lambers
 *
 */

PPOLY	PartialPoly(ppl, var)
PPOLY	ppl;
short	var;
{
    PTERM		ptrmTerm;
    PTERM		ptrmCopy;
    PPOLY		pplDerivative;

    ptrmCopy = ppl->ptrmFirst;

    /* Differentiate each term of the polynomial */
   
    for (ptrmTerm = ptrmCopy; (ptrmTerm != NULL); ptrmTerm = 
      ptrmTerm->ptrmNext) {

	ptrmTerm->coef *= ptrmTerm->exps[var];
	if (ptrmTerm->exps[var]) --ptrmTerm->exps[var];
    }
    pplDerivative = (PPOLY) MyMalloc(sizeof(POLY));
    pplDerivative->ptrmFirst = ptrmCopy;
    return(pplDerivative);
}

