/*
 *  Module:   polynomial print
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"
#include <stdio.h>

/*
 *   Function:	PrintPoly
 *
 *   Purpose:	This function prints a polynomial to standard output.
 *
 *   Author:    Lambers
 *
 */

void	PrintPoly(pplPoly)
PPOLY	pplPoly;
{
    SCALAR	scCoef;
    PTERM	ptrmTerm;
    short	expx, expy, expz;


    ptrmTerm = pplPoly->ptrmFirst;
    while (ptrmTerm != NULL) {
	scCoef = ptrmTerm->coef;
	expx = ptrmTerm->exps[0];
	expy = ptrmTerm->exps[1];
	expz = ptrmTerm->exps[2];
	if (scCoef) { 
	    if ( scCoef != 1.0 || (expx == 0 && expy == 0 && expz == 0) )
	        printf("%lf", scCoef);
	    if (expx) {
		printf("x");
		if (expx != 0 && expx != 1) printf("^%d", expx);
	    }
	    if (expy) {
		printf("y");
		if (expy != 0 && expy != 1) printf("^%d", expy);
	    }
	    if (expz) {
		printf("z");
		if (expz != 0 && expz != 1) printf("^%d", expz);
	    }
	    printf(" ");
	    if ((ptrmTerm->ptrmNext != NULL) && (ptrmTerm->ptrmNext->coef > 0))
	        printf("+ ");
	}
	ptrmTerm = ptrmTerm->ptrmNext;
    }
    printf("\n");
    printf("\n");
}

