/*
 *  Module:  polynomial test
 *
 *  Library: mathbase.a (project Riemann math routines)
 *
 *  Author:  Bret Johnson
 *
 *  Purpose: This routine is used to test the polynomial parser.  This routine
 *	     simply parses the polynomial passed on the command line and prints
 *	     out the parsed polynomial or the message "Bad polynomial" if the 
 *	     polynomial is incorrectly specified.
 */

#include "master.h"

main(argc, argv)
int	argc;
char   *argv[];
{
    PPOLY	ppl;


    if (argc != 2) {
	printf("Usage: %s polynomial_string\n", argv[0]);
	exit(1);
    }

    if ( (ppl = ParsePoly(argv[1])) == NULL ) {
	printf("Bad polynomial\n");
	exit(1);
    }
    else PrintPoly(ppl);
}

