/*
 *  Module:   power
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	Power
 *
 *   Purpose:   This function allows us to exponentiate correctly, using a 
 *              divide-and-conquer technique.
 *
 *   Author:	Scott Goehring
 *
 */

SCALAR	Power(scx, y)
SCALAR	scx;
short 	y;
{
    SCALAR	scResult;


    scResult=1;
    while (y) {
	if (y&1) scResult*=scx;
	scx*=scx;
	y>>=1;
    }
    return(scResult);
}

