/*
 *  Module:   runge kutta
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	Simps
 *
 *   Purpose:   simps (u l) - used to update u with l as specified by 
 *		Runge-Kutta procedure. u = u + (l1 + 2*l2 + 2*l3 + l4) / 6
 *
 *   Author:	Jim Lambers
 *
 */

SCALAR	simps(scu, ascl)  
SCALAR	scu, ascl[4];
{
    return(scu + ((ascl[0] + (2 * ascl[1]) + (2 * ascl[2]) + ascl[3]) / 6));
}



/*
 *   Function:	ComputeK
 *
 *   Author:	Jim Lambers
 *
 */

void	computek(lng, scDt, scgfunc, pvctkvec, pvctl)
short	lng;
SCALAR	scDt, (*scgfunc)();
PVECTOR	pvctkvec, pvctl;
{
    short	i = 0;

    for (; i < lng; i++)
	pvctkvec->vars[i] = scDt * (scgfunc(i, pvctl));
}



/* 
 *   Function:	RungeKutta
 *
 *   Purpose:   Runge-Kutta (t0 t1 dt uulist &rest glist)
 *              Procede from t0 to t1 step dt
 *              ulist is the point appended with an initial vector
 *              glist is a list of g functions
 *              Second Method of Runge-Kutta
 *
 *   Author:	Jim Lambers
 *
 */

void	RungeKutta(scT0, scT1, lng, scDt, scgfunc, pvctUUList, avctPoints)
SCALAR	scT0, scT1;
short	lng;
SCALAR	scDt, (*scgfunc)();
PVECTOR	pvctUUList;
VECTOR	avctPoints[];
{
    short	i, j;
    SCALAR	scTn, ascTempList[4];
    VECTOR	vctK1, vctK2, vctK3, vctK4, vcttulist, vctulist, vcthalf;


    VctCopy(&vctulist, pvctUUList);
    VctCopy( &(avctPoints[0]), pvctUUList );

    j = 1;
    for (scTn = scT0; scTn <= scT1; scTn += scDt) {
    
	computek(lng, scDt, scgfunc, &vctK1, &vctulist);
	
	VctTimesSc(&vctK1, 0.5, &vcthalf);
	VctPlusVct(&vctulist, &vcthalf, &vcttulist);
	computek(lng, scDt, scgfunc, &vctK2, &vcttulist);
      
	VctTimesSc(&vctK2, 0.5, &vcthalf);
	VctPlusVct(&vctulist, &vcthalf, &vcttulist);
	computek(lng, scDt, scgfunc, &vctK3, &vcttulist);
    
	VctPlusVct(&vctulist, &vctK3, &vcttulist);
	computek(lng, scDt, scgfunc, &vctK4, &vcttulist);
      
	for (i = 0; (i < NUMBER_OF_VARS); i++) {
	    ascTempList[0] = vctK1.vars[i];
	    ascTempList[1] = vctK2.vars[i];
	    ascTempList[2] = vctK3.vars[i];
	    ascTempList[3] = vctK4.vars[i];
	    vctulist.vars[i] = simps(vctulist.vars[i], ascTempList);
	}
 	VctCopy( &(avctPoints[j]), &vctulist );
	j++;
    }
}

