/*
 *  Module:   vector dot product
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	VctDotVct
 *
 *   Purpose:	This function returns the dot product (the inner product) of
 *		the two passed vectors.
 *
 *   Author:    Bret Johnson
 *
 */

SCALAR	VctDotVct(pvctFirst, pvctSecond)
PVECTOR pvctFirst, pvctSecond;
{
    SCALAR	scResult = 0;
    short	i;


    for (i = 0; i < NUMBER_OF_VARS; ++i)
	scResult += pvctFirst->vars[i] * pvctSecond->vars[i];

    return(scResult);
}

