/*
 *  Module:   vector normalize
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	Normalize
 *
 *   Purpose:	This function normalizes the passed vector.
 *
 *   Author:    Jim Lambers (loop induction by Scott Goehring)
 *
 */

void	Normalize(pvct, pvctNormal)
PVECTOR pvct, pvctNormal;
{
    SCALAR	scLength = 0.0;
    short	i;
    SCALAR     *pscOld, *pscNew;


    if (IsZeroVct(pvct)) {
	fprintf(stderr, "Normalize: pvct is zero vector\n");
	exit(1);
    }
    for ( (i = 0), (pscOld = pvct->vars); i < NUMBER_OF_VARS; pscOld++, i++ )
	scLength += (*pscOld) * (*pscOld);      /* loop induction! */

    scLength = sqrt(scLength);

    for ( (i = 0), (pscOld = pvct->vars), (pscNew = pvctNormal->vars); 
      i < NUMBER_OF_VARS; pscOld++, pscNew++, i++ )
	*pscNew = (*pscOld) / scLength;		/* loop induction! */
}

