/*
 *  Module:   vector reflection
 *
 *  Library:  mathbase.a (project Riemann math routines)
 */

#include "master.h"

/*
 *   Function:	Reflection
 *
 *   Purpose:	This function returns the reflection of *pvctFirst at the
 *		plane normal to *pvctSecond.
 *
 *   Author:    Lambers
 *
 */

void	Reflection(pvctFirst, pvctSecond, pvctRefl)
PVECTOR pvctFirst, pvctSecond, pvctRefl;
{
    VECTOR	vctProj;

    Projection(pvctFirst, pvctSecond, &vctProj);
    VctMinusVct(pvctFirst, &vctProj, pvctRefl);
}

