/*
 *  Module:  numerical geodesics
 *
 *  Program: numgeod (numerical geodesics generator for project Riemann)
 *
 *  Author:  Jim Lambers
 *
 *  Purpose: This program inputs from the user an implicit equation for a 
 *           surface, along with some other parameters, (via either an 
 *           interactive user interface or the command line) and computes the 
 *           geodesics on that surface.  All of the work on the equation (i.e., 
 *	     differentiating) is done numerically with Dr. Wolter's quick and
 *           dirty technique.  Some header information and lists of points on 
 *           the geodesics are output to standard output in a format that can be
 *           read by a person or the X11 graphics program xdisp.
 */

#include "master.h"

void 		NumQuick();
void		ProcessArgs();

VECTOR		vctPoint;
short		num;
VECTOR		avctFrame[MAX_DIR];
VECTOR		vctInit;
FILE		*pfOutfile;
short		iterations;
SCALAR		scStep;

main(argc, argv)
     int	argc;
     char	*argv[];
{
    EQN		eqn;
    char 	*sTitle, *sEqn;	
    int		i;


    UserInterface(argc, argv, &vctPoint, &scStep, &iterations, &num, &eqn, 
		  &pfOutfile, &sTitle, &sEqn); 

    /* Output standard header information */
    OutputHeader(pfOutfile, IMP_GEOD, sTitle, eqn.et, &sEqn, FALSE);
 
    /* Output initial point in header */
    fprintf(pfOutfile, "Initial point: (");
    for (i = 0; i < NUMBER_OF_VARS; ++i) {
	fprintf(pfOutfile, "%.10lf", vctPoint.vars[i]);

	if (i != NUMBER_OF_VARS - 1)
	    fprintf(pfOutfile, ", ");
	else fprintf(pfOutfile, ")\n");
    }
    
    /* Output other miscellaneous header information */
    fprintf(pfOutfile, "Step size: %lf\n", scStep);
    fprintf(pfOutfile, "Number of iterations per geodesic: %d\n", iterations);
    fprintf(pfOutfile, "Number of geodesics: %d\n\n", num);

    NumOrthoFrame(vctPoint, num, avctFrame, &eqn);

    for (i = 0; i < num; i++) {
        vctInit = avctFrame[i];
        OutputLineStart(pfOutfile, IMP_GEOD, NULL);
        NumQuick(&vctPoint, &vctInit, scStep, iterations, pfOutfile, &eqn);
    }
}

