/*
 *  Module:  numerical orthonormal frame
 *
 *  Program: numgeod (numerical geodesics generator for project Riemann)
 */

#include "master.h"
 
/*
 *   Function:  NumOrthoFrame
 *
 *   Purpose:   This function computes the orthonormal frame for quick v1.0.
 *
 *   Author:    Jim Lambers
 */

NumOrthoFrame(vctPoint, num, avctFrame, peqn)
     VECTOR	vctPoint, avctFrame[MAX_DIR];
     short	num;
     PEQN	peqn;
{
    VECTOR	vctS, vctTemp, vctK1, vctK2, vctW1, vctW2, vctN, vctE3,
           	vctCross, vctGradPoint;
    SCALAR	scDet, scPhi;
    short	i;

    
    vctTemp.vars[0] = 0.0;
    vctTemp.vars[1] = 1.0;
    vctTemp.vars[2] = 0.0;

    vctE3.vars[0] = 1.0;
    vctE3.vars[1] = 0.0;
    vctE3.vars[2] = 0.0;

    NumGradient(peqn, &vctPoint, &vctGradPoint);
    Normalize(&vctGradPoint, &vctN);
    VctCrossproduct(&vctN, &vctE3, &vctS);

    if (!(VctDotVct(&vctS, &vctS))) 
	VctCrossproduct(&vctTemp, &vctN, &vctS);

    VctCrossproduct(&vctS, &vctN, &vctCross);
    Normalize(&vctCross, &vctW2);
    Normalize(&vctS, &vctW1);

    scDet = NbyDet(vctW1, vctW2, vctN);
    
    if (scDet <= 0.0) 
	VctTimesSc(&vctW2, -1.0, &vctW2);

    scPhi = 2 * PI / num;
    for (i = num - 1; i != -1; i--) {
	VctTimesSc(&vctW1, cos(scPhi * i), &vctK1);
	VctTimesSc(&vctW2, -sin(scPhi * i), &vctK2);
	VctPlusVct(&vctK1, &vctK2, &(avctFrame[i]));
    }
}

