/*
 *  Module:  geodesics
 *
 *  Program: symgeod (symbolic geodesics generator for project Riemann)
 *
 *  Author:  Jim Lambers
 *
 *  Purpose: This program inputs from the user an implicit equation for a 
 *           surface, along with some other parameters, (via either an 
 *           interactive user interface or the command line) and computes the 
 *           geodesics on that surface.  All of the work on the equation (i.e., 
 *	     differentiating) is done symbolically with Dr. Wolter's quick and
 *           dirty technique.  Some header information and lists of points on 
 *           the geodesics are output to standard output in a format that can be
 *           read by a person or the X11 graphics program xdisp.
 */

#define	MAIN
#include "geodesics.h"

main(argc, argv)
int	argc;
char	*argv[];
{
    EQN		eqn;
    char 	*sTitle, *sEqn;	
    int		i;


    UserInterface(argc, argv, &vctPoint, &scStep, &iterations, &num, &eqn, 
      &pfOutfile, &sTitle, &sEqn); 

    /* Output standard header information */
    OutputHeader(pfOutfile, IMP_GEOD, sTitle, eqn.et, &sEqn, FALSE);
 
    /* Output initial point in header */
    fprintf(pfOutfile, "Initial point: (");
    for (i = 0; i < NUMBER_OF_VARS; ++i) {
	fprintf(pfOutfile, "%.10lf", vctPoint.vars[i]);

	if (i != NUMBER_OF_VARS - 1)
            fprintf(pfOutfile, ", ");
	else fprintf(pfOutfile, ")\n");
    }
    
    /* Output other miscellaneous header information */
    fprintf(pfOutfile, "Step size: %lf\n", scStep);
    fprintf(pfOutfile, "Number of iterations per geodesic: %d\n", iterations);
    fprintf(pfOutfile, "Number of geodesics: %d\n\n", num);

    for (i = 0; (i < NUMBER_OF_VARS); i++) {
	peqnCopy = CopyEqn(&eqn);
	apeqnPartials[i] = PartialEqn(peqnCopy, i);
    }

    OrthoFrame(apeqnPartials, vctPoint, num, avctFrame);

    for (i = 0; i < num; i++) {
	vctInitVct = avctFrame[i];
	OutputLineStart(pfOutfile, IMP_GEOD, NULL);
	quick(&eqn, apeqnPartials, &vctPoint, &vctInitVct, scStep, iterations, 
          pfOutfile);
    } 
}

