/*
*  Module:  allocate named color
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "xdisp.h"

/*
*  Function: AllocNamedColor
*
*  Purpose: This function allocates the passed color (either specified by name
*           or by a hex string) in the color table and returns a pixel value  
*	    for that color.
*
*  Author:  Wayne Dyksen
*/

Pixel AllocNamedColor(sColorName)
char *sColorName;
{
   XColor xcl;


   if (XParseColor(pds, cm, sColorName, &xcl) == 0)
      FatalExit(FALSE, "Cannot parse color \"%s\"", sColorName);
   if (XAllocColor(pds, cm, &xcl) == 0)
      FatalExit(FALSE, "Cannot XAllocColor for color \"%s\"", 
        sColorName);

   return xcl.pixel;
}

