/*
*  Module:  create control window
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"
#include <X11/cursorfont.h>

/*
*  Function: CreateControlWindow
*
*  Purpose: This function creates the control window and its children and maps
*	    these windows.  "sGeometry" specifies the control window's position.
*	    This function also initializes a cursor for the windows, selects
*	    their input events, and gives the window manager appropriate hints.
*
*  Author:  Bret Johnson
*/

void CreateControlWindow(sGeometry)
char	*sGeometry;
{
    int 	 SliderBarOriginX;	/* X coordinate of slider bar windows */
    long	 ChildEventMask;
    Cursor	 cr;
    XSizeHints   xsh;
    int		 PositionX, PositionY;
    BOOL	 bPosition;


    /* Parse the command line and resource database geometry strings */
    bPosition = MyGeometry(sGeometry, "ControlGeometry", ControlWindowWidth,
      ControlWindowHeight, &PositionX, &PositionY, &ControlWindowWidth,
      &ControlWindowHeight, TRUE);

    wnControl = XCreateSimpleWindow(pds, DefaultRootWindow(pds), PositionX, 
      PositionY, (unsigned int) ControlWindowWidth, 
      (unsigned int) ControlWindowHeight, 1, pxlBlack, pxlWhite);

    /* The control window uses the left arrow cursor */
    cr = XCreateFontCursor(pds, XC_left_ptr);
    XDefineCursor(pds, wnControl, cr);

    /* Give the window manager hints to always keep the control window */
    /*   ControlWindowWidth x ControlWindowHeight */
    xsh.width = ControlWindowWidth;
    xsh.height = ControlWindowHeight;
    xsh.min_width = ControlWindowWidth;
    xsh.max_width = ControlWindowWidth;
    xsh.min_height = ControlWindowHeight;
    xsh.max_height = ControlWindowHeight;
    xsh.flags = USSize | PMinSize | PMaxSize;

    /* If the user specified a position, give the window manager a hint to */
    /*   position the window there */
    if (bPosition) {
        xsh.x = PositionX;
        xsh.y = PositionY;
        xsh.flags |= USPosition;
    }

    XSetNormalHints(pds, wnControl, &xsh);
    
    /* Set the control window title bar string and icon string */
    XStoreName(pds, wnControl, "3D Control Window");
    XSetIconName(pds, wnControl, "3D Control Window");

    /* Create the child windows */

    SliderBarOriginX = LEFT_BORDER + MaxSliderBarLabelWidth + 
      MaxSliderBarMinLabelWidth;

    wnTheta = XCreateSimpleWindow(pds, wnControl, SliderBarOriginX, 
      xptTheta.y - SliderBarHeight + 1, (unsigned int) SliderBarWidth, 
      (unsigned int) SliderBarHeight, 0, 
      pxlBlack, pxlWhite);

    wnEta = XCreateSimpleWindow(pds, wnControl, SliderBarOriginX, 
      xptEta.y - SliderBarHeight + 1, (unsigned int) SliderBarWidth, 
      (unsigned int) SliderBarHeight, 0, pxlBlack, pxlWhite);

    wnDistance = XCreateSimpleWindow(pds, wnControl, SliderBarOriginX, 
      xptDistance.y - SliderBarHeight + 1, (unsigned int) SliderBarWidth, 
      (unsigned int) SliderBarHeight, 0, pxlBlack, pxlWhite);
 
    wnParallel = XCreateSimpleWindow(pds, wnControl, xptParallel.x, 
      xptParallel.y - CheckBoxHeight + 1, (unsigned int) CheckBoxWidth, 
      (unsigned int) CheckBoxHeight, 0, pxlBlack, pxlWhite);
 
    wnConnect1 = XCreateSimpleWindow(pds, wnControl, xptConnect1.x, 
      xptConnect1.y - CheckBoxHeight + 1, (unsigned int) CheckBoxWidth, 
      (unsigned int) CheckBoxHeight, 0, pxlBlack, pxlWhite);

    wnConnect2 = XCreateSimpleWindow(pds, wnControl, xptConnect2.x, 
      xptConnect2.y - CheckBoxHeight + 1, (unsigned int) CheckBoxWidth, 
      (unsigned int) CheckBoxHeight, 0, pxlBlack, pxlWhite);

    wnPAR = XCreateSimpleWindow(pds, wnControl, xptPAR.x, 
      xptPAR.y - CheckBoxHeight + 1, (unsigned int) CheckBoxWidth, 
      (unsigned int) CheckBoxHeight, 0, pxlBlack, pxlWhite);

    wnAutoRedraw = XCreateSimpleWindow(pds, wnControl, xptAutoRedraw.x,
      xptAutoRedraw.y - CheckBoxHeight + 1, (unsigned int) CheckBoxWidth, 
      (unsigned int) CheckBoxHeight, 0, pxlBlack, pxlWhite);

    wnEqnTitle = XCreateSimpleWindow(pds, wnControl, xptEqnTitle.x,
      xptEqnTitle.y - CheckBoxHeight + 1, (unsigned int) CheckBoxWidth, 
      (unsigned int) CheckBoxHeight, 0, pxlBlack, pxlWhite);

    wnRedraw = XCreateSimpleWindow(pds, wnControl, xptRedraw.x, 
      xptRedraw.y - ButtonHeight + 1, (unsigned int) ButtonWidth, 
      (unsigned int) ButtonHeight, 0, pxlBlack, pxlWhite);

    /* Solicit expose events from control window and its children */
    XSelectInput(pds, wnControl, ExposureMask | KeyPressMask | ButtonPressMask |
        OwnerGrabButtonMask);
    ChildEventMask = ButtonPressMask | OwnerGrabButtonMask;
    XSelectInput(pds, wnTheta, ChildEventMask);
    XSelectInput(pds, wnEta, ChildEventMask);
    XSelectInput(pds, wnDistance, ChildEventMask);
    XSelectInput(pds, wnParallel, ChildEventMask);
    XSelectInput(pds, wnConnect1, ChildEventMask);
    XSelectInput(pds, wnConnect2, ChildEventMask);
    XSelectInput(pds, wnPAR, ChildEventMask);
    XSelectInput(pds, wnAutoRedraw, ChildEventMask);
    XSelectInput(pds, wnEqnTitle, ChildEventMask);
    XSelectInput(pds, wnRedraw, ChildEventMask);

    /* Map all of the windows */
    XMapWindow(pds, wnControl);
    XMapSubwindows(pds, wnControl);
}

