/*
*  Module:  draw button
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"

/*
*  Function: DrawButton
*
*  Purpose: This function draws the button with the passed window and label.
*	    The button is gray if bGray is TRUE.
*
*  Author:  Bret Johnson
*/

void DrawButton(wnButton, sLabel, bGray)
Window		 wnButton;
char	     	*sLabel;
BOOL		 bGray;
{
    GC		gc;


    if (bGray)
	gc = gcGray;
    else 
        gc = gcControl;

    /* Clear the button window */
    XClearWindow(pds, wnButton);

    /* Draw the button itself */
    XDrawRectangle(pds, wnButton, gc, 0, 0, ButtonWidth - 1, ButtonHeight - 1);
    
    /* Draw the button label */
    XDrawString(pds, wnButton, gc, BUTTON_BORDER, 
      ButtonHeight - 1 - BUTTON_BORDER, sLabel, strlen(sLabel));
}

