/*
*  Module:  draw check box
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"

/*
*  Function: DrawCheckBox
*
*  Purpose: This function draws a check box with window wnCheckBox at position
*           x, y relative to wnMain.  sLabel is the check box label.  bCheck and
*	    bGray specify whether the check box is checked and/or grayed.  
*	    Grayed check boxes are never checked.
*
*  Author:  Bret Johnson
*/

void DrawCheckBox(x, y, wnMain, wnCheckBox, sLabel, bCheck, bGray)
int	 x, y;
Window	 wnMain, wnCheckBox;
char	*sLabel;
BOOL	 bCheck;
BOOL	 bGray;
{
    GC		gc;

    /* If the check box is grayed, clear all of the check box text */
    if (bGray)
        XClearArea(pds, wnControl, x, y - FontAscent, x + MaxCheckBoxLabelWidth,
	  TrueCharHeight, False);

    /* Clear the check box window */
    XClearWindow(pds, wnCheckBox);

    if (bGray)
	gc = gcGray;
    else 
        gc = gcControl;

    /* Draw the check box itself */
    XDrawRectangle(pds, wnCheckBox, gc, 0, 0, CheckBoxWidth - 1, 
      CheckBoxHeight - 1);

    /* If the caller wishes the box checked and it is not grayed, then put */
    /*   an X in it */
    if (bCheck && !bGray) {
	XDrawLine(pds, wnCheckBox, gc, 0, 0, CheckBoxWidth - 1, 
          CheckBoxHeight - 1);
	XDrawLine(pds, wnCheckBox, gc, CheckBoxWidth - 1, 0, 0, 
          CheckBoxHeight - 1);
    }
    
    /* Draw the check box label */
    XDrawString(pds, wnMain, gc, x + CheckBoxWidth, y, sLabel, strlen(sLabel));
}

