/*
*  Module:  draw slider bar
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"

/*
*  Function: DrawSliderBar
*
*  Purpose: This function draws the slider bar associted with wnSliderBar at
*           position x, y relative to wnMain.  sLabel, sLabelMin, and sLabelMax
*	    are the slider bar label and labels for the minimum and maximum ends
*	    of the slider bar, respectively.  scMin and scMax are the floating
*	    point values associtated with the minimum and maximum ends of the
*	    slider bar.  scPosition controls where the bar itself is drawn.  If
*	    bGray is TRUE, the slider bar is grayed (and no bar is drawn).  
*	    dbTicMarkFraction specifies the fraction of the slider bar to be
*	    between tic marks.  For example, if dbTicMarkFraction is 1/8, seven
*	    evenly spaced tic marks are drawn which divide the slider bar into
*	    eight equal segements.
*
*  Author:  Bret Johnson
*/

void DrawSliderBar(x, y, wnMain, wnSliderBar, sLabel, sLabelMin, sLabelMax, 
  scPosition, scMin, scMax, bGray, dbTicMarkFraction)
int	 x, y;
Window	 wnMain, wnSliderBar;
char	*sLabel;
char	*sLabelMin, *sLabelMax;
SCALAR	 scPosition, scMin, scMax;
BOOL	 bGray;
double	 dbTicMarkFraction;
{
    GC		gc;
    int		position;	/* X coordinate of current position in slider */
				/*   bar */
    double	dbTicCounter;	/* Counter used to draw tic marks */
    double	dbTicIncrement;	/* Increment between each tic mark */
    

    /* If the slider bar is grayed, clear all of the slider bar text */
    if (bGray)
        XClearArea(pds, wnControl, x, y - FontAscent, x + 
	  MaxSliderBarLabelWidth + MaxSliderBarMinLabelWidth + SliderBarWidth + 
	  MaxSliderBarMaxLabelWidth, TrueCharHeight, False);

    /* Clear the slider bar window */
    XClearWindow(pds, wnSliderBar);

    if (bGray)
	gc = gcGray;
    else 
        gc = gcControl;

    /* Draw the slider bar label */
    XDrawString(pds, wnMain, gc, x, y, sLabel, strlen(sLabel));

    /* Draw the right justified slider bar minimum label */
    XDrawString(pds, wnMain, gc, x + MaxSliderBarLabelWidth + 
      MaxSliderBarMinLabelWidth - MY_TEXT_WIDTH(sLabelMin), y, sLabelMin,
      strlen(sLabelMin));

    /* Draw the slider bar itself */
    XDrawRectangle(pds, wnSliderBar, gc, 0, 0, SliderBarWidth - 1, 
      SliderBarHeight - 1);

    /* Draw the tic marks every dbTicMarkFractionth of the slider bar's width */
    dbTicIncrement = (SliderBarWidth - 3) * dbTicMarkFraction;
    dbTicCounter = dbTicIncrement; 
    while ( ROUND(dbTicCounter) < SliderBarWidth - 3 ) {
	
	XDrawLine( pds, wnSliderBar, gc, ROUND(dbTicCounter) + 1, 0, 
          ROUND(dbTicCounter) + 1, ROUND((double) SliderBarHeight * 
          TIC_HEIGHT_INC) );

	XDrawLine( pds, wnSliderBar, gc, ROUND(dbTicCounter) + 1,
          SliderBarHeight - 1, ROUND(dbTicCounter) + 1, SliderBarHeight - 1 - 
          ROUND((double) SliderBarHeight * TIC_HEIGHT_INC) );

	dbTicCounter += dbTicIncrement;
    }

    /* If slider bar is not grayed, draw the line marking the current slider */
    /*   bar position */
    if (!bGray) {
        position = ROUND( (scPosition - scMin) / (scMax - scMin) * 
          (SCALAR) (SliderBarWidth - 3) ) + 1;
        XDrawLine(pds, wnSliderBar, gc, position, 0, position, 
          SliderBarHeight - 1);
    }

    /* Draw the left justified slider bar maximum label */
    XDrawString(pds, wnMain, gc, x + MaxSliderBarLabelWidth +
      MaxSliderBarMinLabelWidth + SliderBarWidth, y, sLabelMax,
      strlen(sLabelMax));
}

