/*
*  Module:  dump surface
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "xdisp.h"

/*
*  Function: DumpSurface
*
*  Purpose: This function dumps all the information in the passed surface to
*           stdout.  It is useful for debugging.
*
*  Author:  Bret Johnson
*/

void DumpSurface(psr)
PSURFACE   psr;
{
    PLINE	pln;
    int		i, j;


    /* Output type of surface */
    switch (psr->type) {

	case IMP_GEOD:
	    printf("Type of surface: implicit geodesics\n");
	    break;

	case PAR_GEOD:
	    printf("Type of surface: parametric geodesics\n");
	    break;

	case IMP_CURV:
	    printf("Type of surface: implicit curvature lines\n");
	    break;

	case PAR_CURV:
	    printf("Type of surface: parametric curvature lines\n");
	    break;
    }

    if (IS_PARAMETRIC(psr->type))
	printf("Space: %s\n", (psr->bParSpace ? "parametric" : "normal"));

    printf("Title: %s\n", psr->sTitle);
    printf("Created: %s\n", psr->sCreated);

    /* Output the equation type */
    if (psr->et == E_POLY)
	printf("Equation type: polynomial\n");
    else printf("Equation type: expression\n");

    /* Output the implicit equation or parametric equations */
    if (psr->type == IMP_GEOD || psr->type == IMP_CURV)
	printf("Implicit equation: %s\n", psr->sEquation1);
    else {
	printf("Parametric equation 1: %s\n", psr->sEquation1);
	printf("Parametric equation 2: %s\n", psr->sEquation2);
	printf("Parametric equation 3: %s\n", psr->sEquation3);
    }
    printf("Minimum values: X = %lf, Y = %lf, Z = %lf\n", psr->XMin, psr->YMin,
	psr->ZMin);
    printf("Maximum values: X = %lf, Y = %lf, Z = %lf\n", psr->XMax, psr->YMax,
	psr->ZMax);
    printf("Surface size: %lf\n", psr->scSurfaceSize);
    printf("Number of lines: %d\n", psr->LineCount);
    printf("\n");

#if 0
    /* Output each line */
    i = 1;
    for (pln = psr->plnFirst; pln != NULL; pln = pln->plnNext) {
  
        printf("Line %d:\n", i++);
        printf("Length: %d\n", pln->length);
        printf("Direction: %d\n", pln->direction);

        for (j = 0; j < pln->length; ++j)
 	    printf("Point %d: (%lf, %lf, %lf)\n", j+1, pln->papt[j].x, 
	      pln->papt[j].y, pln->papt[j].z);
	 
	printf("\n");
    }
#endif
}

