/*
*  Module:  fatal exit
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "xdisp.h"

/*
*  Function: FatalExit
*
*  Purpose: This printf-like function prints the passed message to stderr.  If
*           bUsage is TRUE, this function prints a usage message to stderr.
*	    This function then exits with an exit code of 1.
*
*  Author:  Bret Johnson
*/

void FatalExit(bUsage, sMessage, w1, w2, w3, w4, w5, w6, w7, w8, w9)
BOOL    bUsage;
char   *sMessage;
int     w1, w2, w3, w4, w5, w6, w7, w8, w9;
{
    char sBuffer[200]; 

    sprintf(sBuffer, sMessage, w1, w2, w3, w4, w5, w6, w7, w8, w9);
    fprintf(stderr, "%s: %s\n", GlobalArgv[0], sBuffer);

    if (bUsage) 
        fprintf(stderr, 
"\nUsage: %s [options] [data_file]\n\
Valid options:\n\
  -display display_name\n\
  -db\n\
  -vr\n\
  -nd\n\
  -cl1 curvature_lines_direction_one_color\n\
  -cl2 curvature_lines_direction_two_color\n\
  -clg geodesics_color\n\
  -bg background_color\n\
  -t angle_theta\n\
  -e angle_eta\n\
  -d distance_from_projection_plane\n\
  -fn font_name\n\
  -geometry picture_window_geometry\n\
  -cgeometry control_window_geometry\n\n", sProgramName); 

    exit(1);
}

