/*
*  Module:  handle button press
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"

/*
*  Function: ComputeTransformMatrix
*
*  Purpose: This function does all that is necessary when a button press event
*           occurs in the control window.  pxev is a pointer to the button press
*	    event structure and psr is a pointer to the surface.
*
*  Author:  Bret Johnson
*/

void HandleButtonPress(pxev, psr)
XEvent	   *pxev;
PSURFACE   psr;
{
    Window		wnEvent;
    unsigned int	x;
    BOOL		bOldRedrawValid;


    /* Save the value of bRedrawValid */
    bOldRedrawValid = bRedrawValid;

    wnEvent = pxev->xbutton.window;
    x = (unsigned int) pxev->xbutton.x;

    if ((wnEvent == wnRedraw) && bRedrawValid)
        RedrawSurface(psr, TRUE);
    else if (wnEvent == wnTheta && !(psr->bParSpace)) {
	scTheta = SliderBarInput(x, THETA_MIN, THETA_MAX);
        DrawThetaSliderBar(psr);
        bRedrawValid = TRUE;
    }
    else if (wnEvent == wnEta && !(psr->bParSpace)) {
	scEta = SliderBarInput(x, ETA_MIN, ETA_MAX);
	DrawEtaSliderBar(psr);
        bRedrawValid = TRUE;
    }
    else if ((wnEvent == wnDistance) && !bParallel) {
	scD = SliderBarInput(x, scDistanceMin, scDistanceMax);
	DrawDistanceSliderBar();
        bRedrawValid = TRUE;
    }
    else if ((wnEvent == wnConnect1) && IS_CURVATURE_LINES(psr->type)) {
        bConnect1 = !bConnect1;
	DrawConnect1CheckBox(psr);
        bRedrawValid = TRUE;
    }
    else if ((wnEvent == wnConnect2) && IS_CURVATURE_LINES(psr->type)) {
	bConnect2 = !bConnect2;
	DrawConnect2CheckBox(psr);
        bRedrawValid = TRUE;
    }
    else if (wnEvent == wnParallel && !(psr->bParSpace)) {
        bParallel = !bParallel;
	DrawParallelCheckBox(psr);
	DrawDistanceSliderBar();
        bRedrawValid = TRUE;
    }
    else if (wnEvent == wnPAR) {
        bPAR = !bPAR;
	DrawPARCheckBox();
        bRedrawValid = TRUE;
    }
    else if (wnEvent == wnAutoRedraw) {
        bAutoRedraw = !bAutoRedraw;
	DrawAutoRedrawCheckBox();
    }
    else if (wnEvent == wnEqnTitle) {
        bEqnTitle = !bEqnTitle;
	DrawEqnTitleCheckBox();

        /* Set the picture window title bar string and icon string as the */
        /*   user wishes */
        if (bEqnTitle) {
            XStoreName(pds, wnPicture, sEqnTitle);
            XSetIconName(pds, wnPicture, sEqnTitle);
        }
        else {
            XStoreName(pds, wnPicture, psr->sTitle);
            XSetIconName(pds, wnPicture, psr->sTitle);
        }
    }
    else XBell(pds, 100);		/* Signal error */

    /* Automatically redraw the surface if it would change and if auto redraw */
    /*   is on */
    if (bRedrawValid && bAutoRedraw)
        RedrawSurface(psr, TRUE);

    /* If redrawing was not valid before but the user changed a parameter */
    /*   then allow redrawing */
    if (!bOldRedrawValid && bRedrawValid)
	DrawRedrawButton();
}

