/*
*  Module:  initialize control window
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "control.h"

static char acPatternBits[] = {0x55, 0xaa, 0x55,           /* Gray pattern */
  0xaa, 0x55, 0xaa, 0x55, 0xaa}; 

/*
*  Function: InitializeControlWindow
*
*  Purpose: This function computes all the positioning information for the
*           control window controls and creates, maps, and initializes the 
*	    control window.  sGeometry is command line geometry string or NULL
*	    if the user specified no geometry string on the command line.
*
*  Author:  Bret Johnson
*/

void InitializeControlWindow(sGeometry)
char	*sGeometry;
{
    XCharStruct	        pxcs;
    int			dummy;
    Pixmap		pxPattern;


    /* Make the font associated with the font structure the drawing font */
    XSetFont(pds, gcControl, pxfs->fid);
    XSetFont(pds, gcGray, pxfs->fid);

    /* Set foreground and background colors of the two control window gc's */
    XSetForeground(pds, gcGray, pxlBlack);
    XSetBackground(pds, gcGray, pxlWhite);
    XSetForeground(pds, gcControl, pxlBlack);
    XSetBackground(pds, gcControl, pxlWhite);

    /* Compute the character height */
    XTextExtents(pxfs, "", 0, &dummy, &FontAscent, &FontDescent, &pxcs);
    TrueCharHeight = FontAscent + FontDescent;
    CharHeight = TrueCharHeight + InterlineSpacing;

    /* Compute the size of check boxes, slider bars, and buttons */
    CheckBoxWidth   = FontAscent + 1;
    CheckBoxHeight  = FontAscent + 1;
    SliderBarWidth  = SLIDER_BAR_WIDTH;
    SliderBarHeight = FontAscent + 1;
    ButtonWidth     = MY_TEXT_WIDTH(sRedrawLabel) + 2*BUTTON_BORDER;
    ButtonHeight    = FontAscent + 1 + 2*BUTTON_BORDER;

    /* Compute the maximum width of the slider bar and check box labels */
    MaxSliderBarLabelWidth = MAX( MAX(MY_TEXT_WIDTH(sThetaLabel),
      MY_TEXT_WIDTH(sEtaLabel)), MY_TEXT_WIDTH(sDistanceLabel) );
    MaxCheckBoxLabelWidth = MAX( MAX(MY_TEXT_WIDTH(sParallelLabel),
      MY_TEXT_WIDTH(sConnect1Label)), MAX(MY_TEXT_WIDTH(sConnect2Label),
      MY_TEXT_WIDTH(sPARLabel)) );
    MaxCheckBoxLabelWidth = MAX( MAX(MaxCheckBoxLabelWidth, 
      MY_TEXT_WIDTH(sAutoRedrawLabel)), MY_TEXT_WIDTH(sEqnTitleLabel) );
    MaxSliderBarMinLabelWidth = MAX( MAX(MY_TEXT_WIDTH(sThetaMinLabel),
      MY_TEXT_WIDTH(sEtaMinLabel)), MY_TEXT_WIDTH(sDistanceMinLabel) );
    MaxSliderBarMaxLabelWidth = MAX( MAX(MY_TEXT_WIDTH(sThetaMaxLabel),
      MY_TEXT_WIDTH(sEtaMaxLabel)), MY_TEXT_WIDTH(sDistanceMaxLabel) );

    ControlWindowWidth = LEFT_BORDER + MaxSliderBarLabelWidth + 
      MaxSliderBarMinLabelWidth + SliderBarWidth + MaxSliderBarMaxLabelWidth + 
      RIGHT_BORDER;

    /* Compute the vertical origin of the various controls */
    xptTheta.y      = CharHeight;
    xptEta.y        = xptTheta.y + CharHeight;
    xptDistance.y   = xptEta.y + CharHeight;
    xptParallel.y   = xptDistance.y + CharHeight + CharHeight;
    xptConnect1.y   = xptParallel.y + CharHeight;
    xptConnect2.y   = xptConnect1.y + CharHeight;
    xptPAR.y        = xptConnect2.y + CharHeight;
    xptAutoRedraw.y = xptPAR.y + CharHeight;
    xptEqnTitle.y   = xptAutoRedraw.y + CharHeight;
    xptRedraw.y     = xptParallel.y + BUTTON_BORDER;

    /* Compute the horizontal origin of the various controls */
    xptTheta.x      = LEFT_BORDER;
    xptEta.x        = LEFT_BORDER;
    xptDistance.x   = LEFT_BORDER;
    xptParallel.x   = LEFT_BORDER;
    xptConnect1.x   = LEFT_BORDER;
    xptConnect2.x   = LEFT_BORDER;
    xptPAR.x        = LEFT_BORDER;
    xptAutoRedraw.x = LEFT_BORDER;
    xptEqnTitle.x   = LEFT_BORDER;
    xptRedraw.x	    = ControlWindowWidth - RIGHT_BORDER - ButtonWidth + 1;

    ControlWindowHeight = xptEqnTitle.y + (FontDescent - 1) + InterlineSpacing;

    /* Create and map the control window */
    CreateControlWindow(sGeometry);

    /* Make gcGray draw text and graphics in gray */
    pxPattern = XCreateBitmapFromData(pds, wnControl, acPatternBits, 8, 8);
    XSetStipple(pds, gcGray, pxPattern);
    XSetFillStyle(pds, gcGray, FillStippled);
}

