/*
*  Module:  initialize picture window
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "xdisp.h"

/*
*  Function: InitializePictureWindow
*
*  Purpose: This function creates the picture window, initializes it with the
*	    appropriate window mananger hints, selects its input events, and
*	    maps it.  sGeometry is the command line geometry string for the
*	    picture window.  psr is a pointer to the surface to be displayed in
*	    the window.
*
*  Author:  Bret Johnson
*/

void InitializePictureWindow(sGeometry, psr)
char	  *sGeometry;
PSURFACE   psr;
{
    int	        PositionX, PositionY;
    BOOL        bPosition;
    XSizeHints	xsh;


    /* Parse the command line and resource database geometry strings */
    bPosition = MyGeometry(sGeometry, "Geometry", DEFAULT_PICTURE_WIDTH,
      DEFAULT_PICTURE_HEIGHT, &PositionX, &PositionY, &PictureWindowWidth,
      &PictureWindowHeight, FALSE); 

    if (PictureWindowWidth <= 0 || PictureWindowHeight <= 0)
	FatalExit(FALSE, 
          "Both picture window dimensions must be greater than zero");

    wnPicture = XCreateSimpleWindow(pds, DefaultRootWindow(pds), PositionX, 
      PositionY, (unsigned int) PictureWindowWidth, 
      (unsigned int) PictureWindowHeight, 1, pxlBlack, pxlBackground);

    /* Give the window manager a hint to size the window as desired */
    xsh.width = PictureWindowWidth;
    xsh.height = PictureWindowHeight;
    xsh.flags = USSize;

    /* If the user specified a position, give the window manager a hint to */
    /*   position the window there */
    if (bPosition) {
        xsh.x = PositionX;
	xsh.y = PositionY;
	xsh.flags |= USPosition;
    }

    XSetNormalHints(pds, wnPicture, &xsh);

    /* Set the picture window title bar string and icon string as the user */
    /*   wishes */
    if (bEqnTitle) {
        XStoreName(pds, wnPicture, sEqnTitle);
        XSetIconName(pds, wnPicture, sEqnTitle);
    }
    else {
        XStoreName(pds, wnPicture, psr->sTitle);
        XSetIconName(pds, wnPicture, psr->sTitle);
    }

    XSetWindowBackground(pds, wnPicture, pxlBackground);

    XSelectInput(pds, wnPicture, ExposureMask | KeyPressMask | 
      StructureNotifyMask);

    XMapWindow(pds, wnPicture);
}

