/*
*  Module:  make surface pixmap
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "xdisp.h"

static void CheckPixmap();

/*
*  Function: MakeSurfacePixmap
*
*  Purpose: This function creates a pixmap the same size as the picture window
*	    and sets pxSurface to refer to this pixmap.
*
*  Author:  Bret Johnson
*/

void MakeSurfacePixmap()
{
    Window        wnDummy;
    int		  dummy1;
    unsigned int  dummy2;
    unsigned int  depth;


    XGetGeometry(pds, (Drawable) wnPicture, &wnDummy, &dummy1, &dummy1,
      &PictureWindowWidth, &PictureWindowHeight, &dummy2, &depth);

    pxSurface = XCreatePixmap(pds, wnPicture, PictureWindowWidth, 
      PictureWindowHeight, depth);
    CheckPixmap(pxSurface);
}



/*
*  Function: CheckPixmap
*
*  Purpose: This function checks if the passed pixmap is good (i.e., if the
*           server had enough memory to reserve for the pixmap) and fatal exits
*           with an error message if it isn't.
*/

static void CheckPixmap(px)
Pixmap px;
{
    int    	 dummy1;
    unsigned int dummy2;
    Window       wnDummy;


    if ( XGetGeometry(pds, (Drawable) px, &wnDummy, &dummy1, &dummy1,
      &dummy2, &dummy2, &dummy2, &dummy2) != 1 )
        FatalExit(FALSE, "Cannot create a pixmap.");
}

