/*
*  Module:  multiply matrices
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "xdisp.h"

/*
*  Function: MultiplyMatrices
*
*  Purpose: This function multiplies the A and B matrices and returns the 
*	    result in C.  C cannot be the same matrix as A or B.  All matrices
*	    must be 4 by 4.
*
*  Author:  Bret Johnson
*/

void MultiplyMatrices(A, B, C)
SCALAR	A[4][4], B[4][4], C[4][4];
{
    int		i;		/* Row counter */
    int		j;		/* Column counter */
    int		k;


    for (i = 0; i <  4; ++i)
        for (j = 0; j < 4; ++j) {
	    C[i][j] = 0.0;
	    for (k = 0; k < 4; ++k) 
		C[i][j] += A[i][k] * B[k][j];
	}
}

