/*
*  Module:  my geometry
*
*  Program: xdisp (X11 grahpics displayer for project Riemann)
*/

#include "xdisp.h"

/*
*  Function: MyGeometry
*
*  Purpose: This function parses the command line geometry string 
*	    (sUserGeometry) and the resource geometry string (associated with
*	    resource sResourceName) and combines this information with the
*	    passed defaults for window size (DefaultWidth and DefaultHeight) 
*	    to obtain the desired window position (pX and pY) and size 
*	    (pWidth and pHeight).  sUserGeometry should be NULL if the user
*	    specified no comand line geometry string.  If the command line
*	    geometry is not specified then the resource geometry is used.  If
*	    the resource geometry is not specified then the defaults are used.
*	    (0,0) is always the default position.  If bOverrideSize is TRUE
*	    then the returned window size always equals the default window 
*	    size despite what the user specifies.  This function returns TRUE
*	    if the user specified window positioning information.
*
*  Author:  Bret Johnson
*/

BOOL MyGeometry(sUserGeometry, sResourceName, DefaultWidth, DefaultHeight, 
  pX, pY, pWidth, pHeight, bOverrideSize)
char	*sUserGeometry;
char	*sResourceName;
int	 DefaultWidth, DefaultHeight;
int	*pX, *pY;
int	*pWidth, *pHeight;
BOOL	 bOverrideSize;
{
    char	*sGeometry;
    int		 FlagMask;
    char	 sBuffer[50];


    /* Initialize values to their defaults */
    *pWidth = DefaultWidth;
    *pHeight = DefaultHeight;
    *pX	= 0;
    *pY = 0;

    /* If the user did not specify a geometry on the command line, check the */
    /*   resource database for a geometry */
    if (sUserGeometry == NULL)
	sGeometry = XGetDefault(pds, sProgramName, sResourceName);
    else sGeometry = sUserGeometry;

    /* If their is neither a command line nor a resource database geometry, */
    /*   use the passed defaults and allow the user to position the window */
    /*   himself */
    if (sGeometry == NULL)
	return FALSE;

    sprintf(sBuffer, "%dx%d+0+0", DefaultWidth, DefaultHeight);
    FlagMask = XGeometry(pds, screen, sGeometry, sBuffer, 0, 1, 1, 0, 0, pX,
	pY, pWidth, pHeight);

    /* If the caller does not wish to allow the user control over the window */
    /*   size, use the default size */
    if (bOverrideSize) {
	*pWidth = DefaultWidth;
	*pHeight = DefaultHeight;
    }

    /* Return TRUE if and only if the user specified window positioning */
    return (FlagMask & XValue) || (FlagMask & YValue);
}

